#########################################################################
#	File:			due_export.t										#
#	Description:	Export data from Saved Object Reports module		#
#					to a text file (for client CTV)						#
#	Version:		3													#
#	Created:		071015												#
#	Modified last:	231015												#
#	Written By:		Kim Stahnke											#
#	Copyright:		Farmers WIFE S.L.									#
#########################################################################

# This script is used by Run Script files, placed in the scripts/saved_obj_reports folder.

proc due:dict_get {thedict key} {
	return [dict get $thedict $key]
}

proc due:export_due {} {
	# due_init comes from due:get_export_menu_items, index 1
	set due [due:init]
	set due_export_list [list]

	# Pick up data for export
	set obj $::OBJ_REPORT
	set emp [list]
	foreach object_in_report [lindex $obj 5] {
		set contact_data [lindex $object_in_report 26]
		lappend contact_data [lindex $object_in_report 22]
		lappend contact_data [lindex $object_in_report 24]
		lappend emp $contact_data
	}

	foreach e $emp {
		set D_NAISSANCE_SAL [generic:string_replace [lindex $e 17 5 2] "\/" ""]
		set N_SECU_DOC [generic:string_replace [lindex $e 17 1 2] " " ""]
		set D_EMBAUCHE [generic:string_strip_illegal [generic:intday_to_date_format [lindex $e 18]]]
		set H_EMBAUCHE [generic:string_replace [generic:inttime_to_time [lindex $e 19]] ":" ""]

		set data [list]

		lappend data "** DUE LIST **";						#  0 Réservé pour l'épouse Agriculteurs §:-)
		lappend data "";									#  1 Réservé
		lappend data "DUE ";								#  2 C_APPLICATION		Application Code to Run. MUST be filled with "DUE + 1 BLANK"
		lappend data "";									#  3 Réservé
		lappend data "";									#  4 Réservé
		lappend data "";									#  5 Réservé
		lappend data "912";									#  6 N_LG_MESS			Record Length (excl. header) in Chars
		lappend data [due:dict_get $due "C_VERSION"];		#  7 C_VERSION			Version Message (TST for test, 120 for Operating Message)
		lappend data "";									#  8 Réservé
		lappend data [due:dict_get $due "LIBRE_1"];			#  9 LIBRE_1			Internal Reference for Client - not used by system
		lappend data "";									# 10 Réservé
		lappend data "";									# 11 Réservé
		lappend data [due:dict_get $due "C_URSSAF"];		# 12 C_URSSAF			Code of the Receiving URSSAF Data
		lappend data [due:dict_get $due "N_SIRET"];			# 13 N_SIRET			SIRET No. of Employer
		lappend data "";									# 14 Réservé
		lappend data [due:dict_get $due "L_RAISON_SOC_1"];	# 15 L_RAISON_SOC_1		Name or Business Name (line 1)
		lappend data "";									# 16 Réservé
		lappend data [due:dict_get $due "L_ADR_EMP_1"];		# 17 L_ADR_EMP_1		Company Address 1
		lappend data [due:dict_get $due "L_ADR_EMP_2"];		# 18 L_ADR_EMP_2		Company Address 2
		lappend data [due:dict_get $due "C_POSTAL_EMP"];	# 19 C_POSTAL_EMP		Company Zip Code
		lappend data [due:dict_get $due "L_BUR_DIST_EMP"];	# 20 L_BUR_DIST_EMP		Company City (...at least, we'll always have...)
		lappend data [lindex $e 2];							# 21 L_NOM_PATRO_SAL	Last Name of the Employee
		lappend data [lindex $e 1];							# 22 L_PRENOMS_SAL		First Name of the Employee
		lappend data $N_SECU_DOC;							# 23 N_SECU_DOC			Social Security Number of the Employee (No Blanks)
		lappend data $D_NAISSANCE_SAL;						# 24 D_NAISSANCE_SAL	Birth Date of the Employee (No Blanks)
		lappend data [lindex $e 17 6 2];					# 25 L_LIEU_NAISS_SAL	Birth Place of the Employee
		lappend data "";									# 26 Réservé
		lappend data $D_EMBAUCHE;							# 27 D_EMBAUCHE			Hiring Date (No Blanks)
		lappend data $H_EMBAUCHE;							# 28 H_EMBAUCHE			Hiring Time (No Blanks)
		lappend data "";									# 29 Réservé
		lappend data "";									# 30 Réservé
		lappend data "";									# 31 Réservé
		lappend data [due:dict_get $due "L_RAISON_SOC_2"];	# 32 L_RAISON_SOC_2		Name or Business Name (line 2)
		lappend data [due:dict_get $due "N_TEL_EMP"];		# 33 N_TEL_EMP			Business Telephone
		lappend data "";									# 34 Réservé
		lappend data "";									# 35 Réservé
		lappend data [due:dict_get $due "C_NAF_NN"];		# 36 C_NAF_NN			NAF Code (New Nomenclature)		
		lappend data "";									# 37 Réservé
		lappend data "";									# 38 L_NOM_EPX_SAL		Spouses Name
		lappend data [due:get_sex [lindex $e 17 0 2]];		# 39 C_SEXE_SAL			Sex of the Employee (M or F)
		lappend data "";									# 40 Réservé
		lappend data [lindex $e 17 7 2];					# 41 C_DEPT_NAISS_SAL	Code of Birth Dep't
		lappend data "";									# 42 Réservé
		lappend data [due:dict_get $due "C_TYPE_CONTRAT"];	# 43 C_TYPE_CONTRAT		Code Type of Contract (1,2,3) for CDD, CDI, CTT
		lappend data $D_EMBAUCHE;							# 44 D_FIN_CDD			End Date of CDD (AN Compulsary for CDD-type contracts)
		lappend data "";									# 45 Réservé
		lappend data "";									# 46 N_JJ_ESSAI			Duration of the Trial period
		lappend data "";									# 47 Réservé
		lappend data [due:dict_get $due "C_MT_DCL"];		# 48 C_MT_DCL			Occupational health Center Code (Mandatory exp't for CTT contract)
		lappend data "";									# 49 Réservé
		lappend data "";									# 50 Réservé
		lappend data "";									# 51 Réservé
		lappend data "";									# 52 Réservé
		lappend data "";									# 53 Réservé
		lappend data "";									# 54 Réservé
		lappend data "";									# 55 Réservé

		# Format the data, and add it to list
		lappend due_export_list [due:format_due $data]
	}

	# Save to file
	due:save_due $due_export_list "[due:dict_get $due "EXPORT_TITLE"]"
}

proc due:get_sex {sexe} {
	switch -exact -nocase -- $sexe {
		"Monsieur" {return "M"}
		"Madame" {return "F"}
		"Mademoiselle" {return "F"}
	}
}

proc due:format_due {due_data} {
	set DUE_field_lengths {14 4 15 1 30 8 3 2 44 8 4 3 14 1 32 4 32 32 5 27 32 32 13 8 24 20 8 4 5 2 78 32 11 107 1 5 33 32 1 96 2 35 1 8 11 3 50 10 23 1 2 1 1 1 13}
	set i 1
	set out ""

	# Right-pad the due_data with spaces, to each field length
	foreach dfl $DUE_field_lengths {
		append out [format "%-*s" $dfl [string range [lindex $due_data $i] 0 [expr $dfl-1]]]
		incr i
	}

	return $out
}

proc due:save_due {due_export_list {export_filename ""} {default_extension ".txt"}} {
	# load graphical toolkit for tcl = tk
	if {$::PLATFORM == 3} {
	    catch {package require ::External::Tk}
	} else {
	    catch {package require Tk}
	}
	wm withdraw .

	if {$export_filename == ""} {
		set export_filename "DUE_export"
	}

	set ext [file extension $export_filename]
	# Remove extension
	set export_filename [generic:string_replace $export_filename $ext ""]

	# Add date-stamp to filename
	set sec [clock seconds]
	set export_filename "$export_filename [clock format $sec -format %d%m%Y]"

	# Add extension
	if {$ext == ""} {
		set export_filename "$export_filename$default_extension"
	} else {
		set export_filename "$export_filename$ext"
	}

	set path [tk_getSaveFile -defaultextension txt -initialfile $export_filename -parent . -title "Save As"]

	if {$path == ""} {
		# cancelled
		return
	}

	if {[catch {
		set f [open $path w]
		foreach data $due_export_list {
			puts $f $data
		}
		close $f

	} R1]} {
		tk_messageBox -icon error -title "ERROR" -message "ERROR: One Or More Errors Occurred: $R1"
	} else {
		tk_messageBox -icon error -title "Export" -message "Export Done"
	}

}

proc due:popup_export_menu {} {
	set x [winfo pointerx .]
	set y [winfo pointery .]
	
	set VALUE_LIST ""
	set tmp ""
	set export_menu_items [due:get_export_menu_items]
	foreach item $export_menu_items {
		lappend tmp [list [lindex $item 0] 0 0 "due:export_due {[lindex $item 1]}"]
	}
	
	lappend VALUE_LIST [list "0" "" "$tmp" 0]
	
	widget:popup [expr {$x+31}] [expr {$y-3}] $VALUE_LIST {} {} 1
}

